# Branding Setup Guide

## Overview
The Oasis Investor Database System has been configured to display your custom branding including logo and favicon.

---

## 📋 Required Files

### 1. Logo File
**Filename:** `OCFLoogo.png`
**Location:** `/image/logo/OCFLoogo.png`
**Current Status:** ⚠️ PLACEHOLDER - Please upload your logo

#### Specifications
- **File Format:** PNG (recommended with transparent background)
- **Recommended Dimensions:** 200px width × 50px height (or similar aspect ratio)
- **Maximum File Size:** 100KB (for optimal loading speed)
- **Background:** Transparent or white
- **Color:** Should work well on dark blue gradient background

#### Display Locations
The logo will appear in:
- Navigation bar (top left) on all pages
- Next to "Oasis Investor Database System" text
- Scaled to 50px height (auto width)

---

### 2. Favicon File
**Filename:** `favicon.png`
**Location:** `/favicon.png` (root directory)
**Current Status:** ⚠️ PLACEHOLDER - Please upload your favicon

#### Specifications
- **File Format:** PNG
- **Recommended Dimensions:** 32×32px or 64×64px
- **Maximum File Size:** 10KB
- **Background:** Transparent or solid color

#### Display Locations
The favicon will appear in:
- Browser tabs
- Bookmarks
- Browser history
- Desktop shortcuts (when users bookmark)
- Mobile home screen icons

---

## 📤 Upload Instructions

### Method 1: Using FTP/SFTP
1. Connect to your server using FTP client (FileZilla, WinSCP, etc.)
2. Navigate to the investor-database directory
3. Upload `OCFLoogo.png` to `/image/logo/` directory
4. Upload `favicon.png` to the root directory (same level as index.php)

### Method 2: Using File Manager (cPanel, etc.)
1. Login to your hosting control panel
2. Navigate to File Manager
3. Go to investor-database directory
4. Upload `OCFLoogo.png` to `image/logo/` folder
5. Upload `favicon.png` to root folder

### Method 3: Using Command Line (SSH)
```bash
# Navigate to project directory
cd /path/to/investor-database

# Upload logo (example using scp from local machine)
scp OCFLoogo.png user@server:/path/to/investor-database/image/logo/

# Upload favicon
scp favicon.png user@server:/path/to/investor-database/
```

---

## ✅ Verification Checklist

After uploading your files:

### Logo Verification
- [ ] File exists at `/image/logo/OCFLoogo.png`
- [ ] Filename is spelled correctly (case-sensitive)
- [ ] File size is under 100KB
- [ ] Navigate to dashboard - logo appears in navigation bar
- [ ] Logo is visible and not distorted
- [ ] Logo looks good on both desktop and mobile

### Favicon Verification
- [ ] File exists at `/favicon.png` (root directory)
- [ ] Filename is `favicon.png` (lowercase)
- [ ] File size is under 10KB
- [ ] Hard refresh browser (Ctrl+F5 or Cmd+Shift+R)
- [ ] Favicon appears in browser tab
- [ ] Favicon appears when bookmarking page

---

## 🎨 Branding Elements Applied

### Application Name
- **Full Name:** Oasis Investor Database System
- **Short Name:** Oasis
- **Display Location:** Navigation bar, page titles, footer

### Color Scheme
- **Primary Navigation:** Blue gradient (#1e3c72 to #2a5298)
- **Text Color:** White (on navigation)
- **Logo Background:** Dark blue gradient

### Responsive Sizing
The logo automatically adjusts for different screen sizes:
- **Desktop (992px+):** 50px height
- **Tablet (768px-991px):** 40px height
- **Mobile (< 768px):** 35px height

---

## 🔧 Customization Options

### Changing Logo Size
Edit `css/style.css` and find:
```css
.brand-logo {
    height: 50px;
    width: auto;
    object-fit: contain;
}
```

Adjust the `height` value as needed.

### Changing Application Name
Edit `includes/config.php`:
```php
define('APP_NAME', 'Oasis Investor Database System');
```

### Adding Additional Branding
You can add more branding elements by:
1. Adding images to `/image/` directory
2. Referencing them in your custom CSS
3. Using them in page content

---

## 🐛 Troubleshooting

### Logo Not Appearing
**Problem:** Logo doesn't show in navigation bar

**Solutions:**
1. Check filename is exactly `OCFLoogo.png` (case-sensitive)
2. Verify file is in `/image/logo/` directory
3. Check file permissions (should be 644)
4. Clear browser cache (Ctrl+F5)
5. Check browser console for 404 errors
6. Verify image file is not corrupted

### Favicon Not Showing
**Problem:** Favicon doesn't appear in browser tab

**Solutions:**
1. Hard refresh browser (Ctrl+Shift+F5)
2. Clear browser cache completely
3. Check filename is `favicon.png` (lowercase)
4. Verify file is in root directory
5. Try different browser
6. Wait a few minutes (browsers cache favicons)

### Logo Appears Distorted
**Problem:** Logo is stretched or squashed

**Solutions:**
1. Check original image dimensions
2. Use PNG with transparent background
3. Ensure aspect ratio is preserved
4. Adjust CSS `object-fit` property if needed

### File Upload Fails
**Problem:** Cannot upload files

**Solutions:**
1. Check directory permissions (755 for folders)
2. Verify file size limits on server
3. Check available disk space
4. Ensure directories exist
5. Try renaming file (no special characters)

---

## 📁 Directory Structure

```
investor-database/
├── favicon.png                     ⬅️ Upload here
├── image/
│   └── logo/
│       ├── OCFLoogo.png           ⬅️ Upload here
│       └── PLACE_LOGO_HERE.txt
├── index.php
├── includes/
│   ├── config.php                 (APP_NAME defined here)
│   └── header.php                 (Logo & favicon referenced)
└── css/
    └── style.css                  (Logo styling)
```

---

## 🎯 Quick Start

**For immediate setup:**

1. **Prepare Your Files**
   - Logo: `OCFLoogo.png` (200×50px recommended)
   - Favicon: `favicon.png` (32×32px or 64×64px)

2. **Upload Files**
   - Logo → `/image/logo/OCFLoogo.png`
   - Favicon → `/favicon.png`

3. **Verify**
   - Visit `index.php`
   - Check navigation bar for logo
   - Check browser tab for favicon
   - Test on mobile device

4. **Done!**
   Your branding is now live across all pages

---

## 📞 Support

If you encounter issues:

1. Check this guide's troubleshooting section
2. Verify file paths and names
3. Check browser console for errors
4. Review server error logs
5. Contact system administrator

---

## 🔄 Version History

**Version 2.0** - December 2024
- Added logo support
- Added favicon support
- Updated to "Oasis Investor Database System"
- Responsive logo sizing

**Version 1.0** - December 2024
- Initial release
- Basic branding

---

**Last Updated:** December 2024
**Status:** Ready for branding files ✓
