@echo off
REM ============================================================================
REM Oasis Investor Database System - Create Download Package (Windows)
REM Version 2.1
REM This script creates a clean downloadable package for Windows users
REM ============================================================================

echo ======================================================================
echo   Creating Oasis Investor Database System v2.1 Download Package
echo ======================================================================
echo.

REM Set variables
set VERSION=2.1
set PACKAGE_NAME=oasis-investor-database-v%VERSION%
set BUILD_DIR=build
set PACKAGE_DIR=%BUILD_DIR%\%PACKAGE_NAME%
set OUTPUT_FILE=%PACKAGE_NAME%.zip

REM Check if 7-Zip is available
where 7z >nul 2>nul
if %ERRORLEVEL% NEQ 0 (
    echo ERROR: 7-Zip is not installed or not in PATH
    echo Please install 7-Zip from https://www.7-zip.org/
    echo Or use the manual packaging method below
    echo.
    goto MANUAL
)

REM Create build directory
echo [1/6] Creating build directory...
if exist %BUILD_DIR% rmdir /s /q %BUILD_DIR%
mkdir %PACKAGE_DIR%

REM Copy core files
echo [2/6] Copying core application files...
mkdir %PACKAGE_DIR%\css
mkdir %PACKAGE_DIR%\database
mkdir %PACKAGE_DIR%\forms
mkdir %PACKAGE_DIR%\includes
mkdir %PACKAGE_DIR%\image\logo

REM Copy PHP files
copy index.php %PACKAGE_DIR%\ >nul
copy test_connection.php %PACKAGE_DIR%\ >nul

REM Copy forms
copy forms\client_form.php %PACKAGE_DIR%\forms\ >nul
copy forms\search_clients.php %PACKAGE_DIR%\forms\ >nul
copy forms\contact_records.php %PACKAGE_DIR%\forms\ >nul
copy forms\staff_management.php %PACKAGE_DIR%\forms\ >nul
copy forms\introducer_form.php %PACKAGE_DIR%\forms\ >nul
copy forms\introducers_list.php %PACKAGE_DIR%\forms\ >nul

REM Copy includes
copy includes\config.php %PACKAGE_DIR%\includes\ >nul
copy includes\db.php %PACKAGE_DIR%\includes\ >nul
copy includes\header.php %PACKAGE_DIR%\includes\ >nul
copy includes\footer.php %PACKAGE_DIR%\includes\ >nul

REM Copy CSS
copy css\style.css %PACKAGE_DIR%\css\ >nul

REM Copy database
copy database\schema.sql %PACKAGE_DIR%\database\ >nul
copy database\sample_data.sql %PACKAGE_DIR%\database\ >nul
copy database\add_introducers.sql %PACKAGE_DIR%\database\ >nul

REM Copy documentation
echo [3/6] Copying documentation...
copy README.md %PACKAGE_DIR%\ >nul
copy START_HERE.md %PACKAGE_DIR%\ >nul
copy SETUP_INSTRUCTIONS.txt %PACKAGE_DIR%\ >nul
copy UPLOAD_CHECKLIST.txt %PACKAGE_DIR%\ >nul
copy QUICK_REFERENCE.md %PACKAGE_DIR%\ >nul
copy SYSTEM_OVERVIEW.md %PACKAGE_DIR%\ >nul
copy DESIGN_IMPROVEMENTS.md %PACKAGE_DIR%\ >nul
copy BRANDING_SETUP.md %PACKAGE_DIR%\ >nul
copy BRANDING_CHANGES_SUMMARY.md %PACKAGE_DIR%\ >nul
copy FILE_MANIFEST.txt %PACKAGE_DIR%\ >nul
copy VERSION.txt %PACKAGE_DIR%\ >nul
copy DOWNLOAD_PACKAGE.md %PACKAGE_DIR%\ >nul
copy CHANGES_v2.1_SUMMARY.md %PACKAGE_DIR%\ >nul
copy INSTALL_v2.1_UPDATE.txt %PACKAGE_DIR%\ >nul
copy database\UPDATE_v2.1_INTRODUCERS.md %PACKAGE_DIR%\database\ >nul

REM Copy placeholder files
echo [4/6] Copying placeholder files...
copy PLACE_FAVICON_HERE.txt %PACKAGE_DIR%\ >nul
copy image\logo\PLACE_LOGO_HERE.txt %PACKAGE_DIR%\image\logo\ >nul
copy image\README.md %PACKAGE_DIR%\image\ >nul

REM Create .htaccess
echo [5/6] Creating security files...
(
echo # Oasis Investor Database System - Apache Configuration
echo # Disable directory browsing
echo Options -Indexes
echo.
echo # Protect sensitive files
echo ^<FilesMatch "^^(config\.php^|\.htaccess^)$"^>
echo     Order allow,deny
echo     Deny from all
echo ^</FilesMatch^>
echo.
echo # Set default charset
echo AddDefaultCharset UTF-8
) > %PACKAGE_DIR%\.htaccess

REM Create robots.txt
(
echo # Oasis Investor Database System
echo # This is a private application - disallow all web crawlers
echo User-agent: *
echo Disallow: /
) > %PACKAGE_DIR%\robots.txt

REM Create README
(
echo ================================================================================
echo OASIS INVESTOR DATABASE SYSTEM v2.0 - DOWNLOAD PACKAGE
echo ================================================================================
echo.
echo Thank you for downloading the Oasis Investor Database System!
echo.
echo QUICK START:
echo -----------
echo 1. Read START_HERE.md for complete getting started guide
echo 2. Read UPLOAD_CHECKLIST.txt for step-by-step deployment
echo 3. Follow the setup instructions carefully
echo.
echo IMPORTANT - BEFORE YOU BEGIN:
echo -----------------------------
echo You must prepare TWO files for upload:
echo.
echo 1. OCFLoogo.png - Your company logo (200x50px PNG^)
echo    Upload to: /image/logo/OCFLoogo.png
echo.
echo 2. favicon.png - Your site favicon (32x32px PNG^)
echo    Upload to: /favicon.png (root directory^)
echo.
echo See BRANDING_SETUP.md for detailed specifications.
echo.
echo VERSION: 2.0 - Oasis Edition
echo RELEASE: December 2024
echo STATUS: Production Ready
echo.
echo ================================================================================
) > %PACKAGE_DIR%\READ_ME_FIRST.txt

REM Create package
echo [6/6] Creating ZIP package...
cd %BUILD_DIR%
7z a -tzip ..\%OUTPUT_FILE% %PACKAGE_NAME%\ -mx9 >nul
cd ..

REM Done
echo.
echo ======================================================================
echo   Package created successfully!
echo ======================================================================
echo.
echo   File: %OUTPUT_FILE%
echo   Location: %CD%\%OUTPUT_FILE%
echo.
echo   Package contents:
echo     - 12 PHP files (application^)
echo     - 3 SQL files (database^)
echo     - 1 CSS file (styling^)
echo     - 15 documentation files
echo     - Directory structure
echo     - Security files
echo.
echo   Ready for distribution!
echo.
echo ======================================================================
echo.
pause
goto END

:MANUAL
echo.
echo ======================================================================
echo   MANUAL PACKAGING INSTRUCTIONS
echo ======================================================================
echo.
echo Since 7-Zip is not available, please package manually:
echo.
echo 1. Create a folder named: %PACKAGE_NAME%
echo.
echo 2. Copy these files/folders into it:
echo    - index.php
echo    - test_connection.php
echo    - forms\ (entire folder^)
echo    - includes\ (entire folder^)
echo    - css\ (entire folder^)
echo    - database\ (entire folder^)
echo    - image\ (entire folder^)
echo    - All .md files
echo    - All .txt files
echo.
echo 3. Right-click the folder and select "Send to > Compressed folder"
echo.
echo 4. Rename to: %OUTPUT_FILE%
echo.
echo ======================================================================
echo.
pause

:END
