# Quick Reference Guide

## Daily Operations Quick Guide

### 🏠 Dashboard Access
- **URL:** `index.php`
- **View:** Statistics, recent clients, recent contacts
- **Quick Actions:** Links to all main functions

---

## 👤 Client Management

### Add New Client
1. Click **Add Client** in navigation
2. Fill required fields (marked with *)
   - First Name, Last Name, Email are mandatory
3. Complete optional sections as needed
4. Click **Create Client**
5. Client ID generated automatically

### Edit Client
1. Search for client or find in dashboard
2. Click **View/Edit** button
3. Modify any fields
4. Click **Update Client**
5. Changes saved immediately

### Client Record Sections
- **Contact Info:** Basic details, address
- **KYC:** Status, ID verification, risk rating
- **Personal:** Age, nationality, occupation, profile
- **Financial:** Income, net worth, source of funds
- **Investment:** Experience, interests, objectives, risk
- **Additional:** Status, assigned staff, notes

---

## 🔍 Search Clients

### Quick Search
- Enter name or email in search box
- Click **Search**

### Advanced Search
Available filters:
- Client Status (Prospect, Active, Inactive, Closed)
- KYC Status (Pending, In Progress, Completed, Expired)
- Risk Rating (Low, Medium, High)
- Investment Experience (None, Limited, Moderate, Extensive)
- Risk Tolerance (Conservative, Moderate, Aggressive)
- Investment Horizon (Short-term, Medium-term, Long-term)
- Country (dropdown from existing data)
- Assigned Staff
- Investment Interests (keyword search)
- Net Worth Range (min/max)
- Age Range (min/max)

**Tip:** Combine multiple filters for precise results

---

## 📞 Contact Records

### Add Contact Record
1. Select client from dropdown
2. Select staff member (yourself)
3. Choose contact type:
   - Newsletter
   - Phone Call
   - Visit
   - Email
   - Video Conference
   - Other
4. Set date and time
5. Enter subject and description
6. Record outcome
7. Set follow-up if needed
8. Click **Add Contact Record**

### View Contact History
- All contacts shown in table
- Filter by specific client
- Click **View** for full details
- Follow-up items highlighted

### Contact Types Usage
- **Newsletter:** Mass email campaigns
- **Phone Call:** Phone discussions
- **Visit:** In-person meetings
- **Email:** Individual emails
- **Video Conference:** Online meetings
- **Other:** Any other type

---

## 👥 Staff Management

### Add Staff Member
1. Click **Staff Management**
2. Enter first name, last name, email
3. Add phone, department, position
4. Ensure **Active** is checked
5. Click **Add Staff Member**

### Edit Staff
1. Find staff in table
2. Click **Edit**
3. Modify fields
4. Click **Update Staff Member**

### Deactivate Staff
1. Edit staff member
2. Uncheck **Active** checkbox
3. Save
4. Staff won't appear in dropdowns but data retained

**Note:** Cannot delete staff with assigned clients

---

## 📊 Status Meanings

### Client Status
- **Prospect:** Potential client, not yet signed
- **Active:** Current active client
- **Inactive:** Client not currently active
- **Closed:** Former client

### KYC Status
- **Pending:** KYC not started
- **In Progress:** Currently being processed
- **Completed:** KYC done, valid
- **Expired:** KYC needs renewal

### Risk Rating
- **Low:** Low-risk client
- **Medium:** Medium-risk client
- **High:** High-risk client (requires enhanced due diligence)

### PEP Status
- **Unknown:** Not yet determined
- **No:** Not a Politically Exposed Person
- **Yes:** Is a PEP (enhanced monitoring required)

---

## 💡 Pro Tips

### Efficient Workflow
1. **New Client Process:**
   - Add client via Client Form
   - Complete KYC section immediately
   - Assign to staff member
   - Record first contact

2. **Regular Updates:**
   - Update KYC dates before expiry
   - Log all client interactions
   - Set follow-up reminders
   - Update net worth annually

3. **Search Shortcuts:**
   - Use broad criteria first, then refine
   - Save common searches mentally (e.g., "High net worth + Active")
   - Filter by assigned staff to see your clients

4. **Contact Tracking:**
   - Always set follow-up for important calls
   - Use descriptive subjects for easy search later
   - Record outcomes immediately while fresh

### Data Entry Best Practices
- **Be Consistent:** Use same format for phone numbers, addresses
- **Be Complete:** Fill all relevant fields for better searching
- **Be Accurate:** Double-check financial figures
- **Be Timely:** Log contacts immediately after they occur

### Dashboard Usage
- Check dashboard daily for overview
- Monitor Pending KYC count
- Review recent contacts for team activity
- Track prospect to active conversion

---

## ⚡ Keyboard Shortcuts

**Forms:**
- `Tab` - Move to next field
- `Shift + Tab` - Move to previous field
- `Enter` - Submit form (when in text field)

**Navigation:**
- Click logo to return to dashboard
- Use browser back button to navigate

---

## 🆘 Common Tasks

### Task: Find all high net worth clients
1. Go to Search Clients
2. Set Minimum Net Worth: 1000000
3. Click Search

### Task: Find clients needing KYC renewal
1. Go to Search Clients
2. Select KYC Status: Expired or Pending
3. Click Search

### Task: View all your assigned clients
1. Go to Search Clients
2. Select your name in Assigned Staff
3. Click Search

### Task: See all contacts this month
1. Go to Contact Records
2. Scroll through table (sorted by date descending)
3. Most recent contacts appear first

### Task: Find clients interested in specific investment
1. Go to Search Clients
2. Enter keyword in Investment Interests field (e.g., "Real Estate")
3. Click Search

---

## 📋 Regular Checklist

### Daily
- [ ] Check dashboard for overview
- [ ] Log any client contacts
- [ ] Review follow-ups due today

### Weekly
- [ ] Review pending KYC approvals
- [ ] Check clients assigned to you
- [ ] Update any outstanding contact records

### Monthly
- [ ] Review prospect conversion rate
- [ ] Update client net worth if applicable
- [ ] Check for expired KYC documents

### Quarterly
- [ ] Comprehensive client reviews
- [ ] Update investment objectives
- [ ] Verify contact information current

---

## 🔐 Data Security Reminders

- Log out when leaving workstation
- Don't share database credentials
- Keep client information confidential
- Report any suspicious access
- Follow your bank's data protection policies

---

## 📞 Getting Help

**Technical Issues:**
- Check SETUP_INSTRUCTIONS.txt
- Review README.md
- Run test_connection.php
- Contact IT support

**Business Questions:**
- Consult your supervisor
- Review client handling policies
- Refer to compliance guidelines

**System Questions:**
- See SYSTEM_OVERVIEW.md for technical details
- Review this Quick Reference
- Contact system administrator

---

## 📄 Related Documents

- **README.md** - Installation and setup
- **SETUP_INSTRUCTIONS.txt** - Quick setup guide
- **SYSTEM_OVERVIEW.md** - Technical documentation
- **database/schema.sql** - Database structure
- **database/sample_data.sql** - Demo data

---

**Last Updated:** December 2024
**Version:** 1.0

*Print this guide or bookmark it for quick reference during daily operations.*
