# Investor Database System

A comprehensive PHP-based investor database system for investment banks to manage client information, KYC due diligence, investment profiles, and contact records.

## Features

### Client Management
- Complete client profile management with contact information
- KYC (Know Your Customer) due diligence tracking
- Personal and financial information
- Investment preferences and objectives
- Age calculation and net worth tracking
- Risk assessment and tolerance profiling

### Search Capabilities
- Advanced search form with multiple criteria:
  - Name and email search
  - Client status filtering
  - KYC status
  - Risk ratings and tolerance levels
  - Investment experience and horizon
  - Geographic filtering by country
  - Staff assignment filtering
  - Investment interests keyword search
  - Financial ranges (net worth, age)

### Contact Records Management
- Track all client interactions
- Multiple contact types: Newsletter, Phone Call, Visit, Email, Video Conference
- Detailed contact history with descriptions and outcomes
- Follow-up tracking system
- Staff member assignment to contacts
- Last contact date tracking

### Staff Management
- Manage bank staff members
- Department and position tracking
- Active/inactive status control
- Client assignment tracking
- Staff members pre-populate dropdowns in contact forms

## Database Schema

### Tables
1. **staff** - Bank employees information
2. **clients** - Comprehensive client records
3. **contact_records** - All client contact history

## Installation Instructions

### Prerequisites
- PHP 7.4 or higher
- MariaDB or MySQL 5.7+
- Apache or Nginx web server
- phpMyAdmin (optional, for easier database management)

### Step 0: Branding Setup (Optional but Recommended)

Upload your branding files:

1. **Logo**: Upload `OCFLoogo.png` to `/image/logo/` directory
   - Recommended size: 200×50px
   - Format: PNG with transparent background

2. **Favicon**: Upload `favicon.png` to root directory
   - Recommended size: 32×32px or 64×64px
   - Format: PNG

See `BRANDING_SETUP.md` for detailed instructions.

### Step 1: Database Setup

1. Create the database and tables:
   ```bash
   mysql -u root -p < database/schema.sql
   ```

   Or using phpMyAdmin:
   - Import the `database/schema.sql` file
   - This will create the `investor_db` database with all tables and sample data

### Step 2: Configure Database Connection

Edit `includes/config.php` and update the database credentials:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_database_user');
define('DB_PASS', 'your_database_password');
define('DB_NAME', 'investor_db');
```

### Step 3: Web Server Configuration

#### Option A: Using PHP Built-in Server (Development)
```bash
cd investor-database
php -S localhost:8000
```

Then access: `http://localhost:8000`

#### Option B: Apache/Nginx (Production)

**Apache:**
1. Copy the `investor-database` folder to your web root (e.g., `/var/www/html/`)
2. Ensure `.htaccess` is enabled if needed
3. Access via: `http://localhost/investor-database/`

**Nginx:**
Configure your server block to point to the `investor-database` directory

### Step 4: File Permissions

Ensure proper permissions (on Linux/Mac):
```bash
chmod -R 755 investor-database
chmod -R 777 investor-database/uploads  # if you add file upload functionality
```

## Usage Guide

### Dashboard
- View system statistics (total clients, active clients, prospects, contacts, pending KYC)
- Quick access to recent clients and contact records
- Color-coded metrics for easy monitoring

### Adding a New Client
1. Navigate to **Add Client** from the menu
2. Fill in the comprehensive form with sections:
   - Contact Information
   - KYC Due Diligence
   - Personal Information
   - Financial Information
   - Investment Information
   - Additional Information
3. Click **Create Client**

### Searching for Clients
1. Navigate to **Search Clients**
2. Use any combination of search criteria:
   - Text search by name/email
   - Filter by status, KYC, risk ratings
   - Filter by investment preferences
   - Set financial and age ranges
3. Click **Search** to view results
4. Click **View** on any result to edit client details

### Managing Contact Records
1. Navigate to **Contact Records**
2. To add a new contact:
   - Select client and staff member from dropdowns
   - Choose contact type (Newsletter, Phone Call, Visit, etc.)
   - Enter date, subject, and description
   - Add outcome and follow-up information
3. View contact history in the table below
4. Filter contacts by specific client if needed

### Managing Staff
1. Navigate to **Staff Management**
2. Add new staff members with department and position
3. Edit existing staff or mark as inactive
4. Active staff appear in dropdowns throughout the system

## Security Considerations

For production use, implement these security enhancements:

1. **Input Validation:** Already implemented with `sanitize_input()` function
2. **Prepared Statements:** Consider switching from string concatenation to prepared statements
3. **Authentication:** Add user login and session management
4. **HTTPS:** Always use SSL/TLS in production
5. **Password Protection:** Add `.htaccess` authentication or PHP session-based auth
6. **Regular Backups:** Set up automated database backups
7. **Error Handling:** Set `display_errors = 0` in production (in `config.php`)

## File Structure

```
investor-database/
├── css/
│   └── style.css              # Styling
├── database/
│   └── schema.sql             # Database schema
├── forms/
│   ├── client_form.php        # Add/Edit client
│   ├── search_clients.php     # Search functionality
│   ├── contact_records.php    # Contact management
│   └── staff_management.php   # Staff management
├── includes/
│   ├── config.php             # Configuration
│   ├── db.php                 # Database connection
│   ├── header.php             # Page header
│   └── footer.php             # Page footer
├── index.php                  # Dashboard
└── README.md                  # This file
```

## Sample Data

The system includes sample staff members:
- John Smith - Senior Advisor
- Sarah Johnson - Investment Advisor
- Michael Brown - Portfolio Manager
- Emily Davis - Junior Advisor
- David Wilson - KYC Officer

You can start adding clients immediately after installation.

## Browser Compatibility

Tested and compatible with:
- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

## Support and Customization

This system can be customized to add:
- Document upload functionality
- Email integration
- Reporting and analytics
- Export to Excel/PDF
- Multi-language support
- Role-based access control
- API integration with CRM systems

## License

This is a custom-built system for investment bank use. All rights reserved.

## Version

Version 1.0 - Initial Release
