-- Smart Authentication Migration Script
-- Version 2.2 - Handles Existing Tables
-- This script checks what exists and migrates safely

USE oasiscapfin_investor_db;

-- ============================================================================
-- STEP 1: CHECK WHAT ALREADY EXISTS
-- ============================================================================

SELECT '========================================' as '';
SELECT 'CHECKING EXISTING TABLES...' as 'STEP 1';
SELECT '========================================' as '';

-- Check for users table
SELECT
    CASE WHEN COUNT(*) > 0 THEN '✓ EXISTS' ELSE '✗ NOT FOUND' END as 'users table',
    COUNT(*) as 'Row Count'
FROM information_schema.tables
WHERE table_schema = 'oasiscapfin_investor_db'
AND table_name = 'users';

-- Check for user_sessions table
SELECT
    CASE WHEN COUNT(*) > 0 THEN '✓ EXISTS' ELSE '✗ NOT FOUND' END as 'user_sessions table',
    COUNT(*) as 'Row Count'
FROM information_schema.tables
WHERE table_schema = 'oasiscapfin_investor_db'
AND table_name = 'user_sessions';

-- Check for activity_log table
SELECT
    CASE WHEN COUNT(*) > 0 THEN '✓ EXISTS' ELSE '✗ NOT FOUND' END as 'activity_log table',
    COUNT(*) as 'Row Count'
FROM information_schema.tables
WHERE table_schema = 'oasiscapfin_investor_db'
AND table_name = 'activity_log';

-- Check for login_attempts table
SELECT
    CASE WHEN COUNT(*) > 0 THEN '✓ EXISTS' ELSE '✗ NOT FOUND' END as 'login_attempts table',
    COUNT(*) as 'Row Count'
FROM information_schema.tables
WHERE table_schema = 'oasiscapfin_investor_db'
AND table_name = 'login_attempts';

-- Show structure of existing users table if it exists
SELECT '========================================' as '';
SELECT 'EXISTING USERS TABLE STRUCTURE' as 'STEP 2';
SELECT '========================================' as '';

SELECT
    COLUMN_NAME,
    COLUMN_TYPE,
    IS_NULLABLE,
    COLUMN_KEY,
    COLUMN_DEFAULT
FROM information_schema.columns
WHERE table_schema = 'oasiscapfin_investor_db'
AND table_name = 'users'
ORDER BY ORDINAL_POSITION;

-- Show structure of existing user_sessions table if it exists
SELECT '========================================' as '';
SELECT 'EXISTING USER_SESSIONS TABLE STRUCTURE' as 'STEP 3';
SELECT '========================================' as '';

SELECT
    COLUMN_NAME,
    COLUMN_TYPE,
    IS_NULLABLE,
    COLUMN_KEY,
    COLUMN_DEFAULT
FROM information_schema.columns
WHERE table_schema = 'oasiscapfin_investor_db'
AND table_name = 'user_sessions'
ORDER BY ORDINAL_POSITION;

-- Show structure of existing activity_log table if it exists
SELECT '========================================' as '';
SELECT 'EXISTING ACTIVITY_LOG TABLE STRUCTURE' as 'STEP 4';
SELECT '========================================' as '';

SELECT
    COLUMN_NAME,
    COLUMN_TYPE,
    IS_NULLABLE,
    COLUMN_KEY,
    COLUMN_DEFAULT
FROM information_schema.columns
WHERE table_schema = 'oasiscapfin_investor_db'
AND table_name = 'activity_log'
ORDER BY ORDINAL_POSITION;

-- Show existing data counts
SELECT '========================================' as '';
SELECT 'EXISTING DATA COUNTS' as 'STEP 5';
SELECT '========================================' as '';

-- Count existing users if table exists
SET @users_count = (
    SELECT COUNT(*)
    FROM information_schema.tables
    WHERE table_schema = 'oasiscapfin_investor_db'
    AND table_name = 'users'
);

SELECT
    'users' as `Table_Name`,
    IFNULL((SELECT COUNT(*) FROM users), 0) as 'Records',
    CASE WHEN @users_count > 0 THEN 'Table exists - has data' ELSE 'Table not found' END as 'Status'
FROM DUAL
WHERE @users_count > 0;

-- Count existing sessions if table exists
SET @sessions_count = (
    SELECT COUNT(*)
    FROM information_schema.tables
    WHERE table_schema = 'oasiscapfin_investor_db'
    AND table_name = 'user_sessions'
);

SELECT
    'user_sessions' as `Table_Name`,
    IFNULL((SELECT COUNT(*) FROM user_sessions), 0) as 'Records',
    CASE WHEN @sessions_count > 0 THEN 'Table exists - has data' ELSE 'Table not found' END as 'Status'
FROM DUAL
WHERE @sessions_count > 0;

-- Count existing activity_log if table exists
SET @activity_count = (
    SELECT COUNT(*)
    FROM information_schema.tables
    WHERE table_schema = 'oasiscapfin_investor_db'
    AND table_name = 'activity_log'
);

SELECT
    'activity_log' as `Table_Name`,
    IFNULL((SELECT COUNT(*) FROM activity_log), 0) as 'Records',
    CASE WHEN @activity_count > 0 THEN 'Table exists - has data' ELSE 'Table not found' END as 'Status'
FROM DUAL
WHERE @activity_count > 0;

-- Final recommendation
SELECT '========================================' as '';
SELECT 'RECOMMENDATION' as 'STEP 6';
SELECT '========================================' as '';

SELECT
    CASE
        WHEN (SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = 'oasiscapfin_investor_db' AND table_name IN ('users', 'user_sessions', 'activity_log')) = 3
        THEN 'OPTION A: All 3 tables exist - Review structures and decide to MERGE or RENAME'
        WHEN (SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = 'oasiscapfin_investor_db' AND table_name IN ('users', 'user_sessions', 'activity_log')) > 0
        THEN 'OPTION B: Some tables exist - Review structures and decide to MERGE or RENAME'
        ELSE 'OPTION C: No conflicts - Run standard installation'
    END as 'Recommended Action';

SELECT '========================================' as '';
SELECT 'ANALYSIS COMPLETE!' as '';
SELECT 'Review results above to determine next steps.' as '';
SELECT '========================================' as '';
