<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/auth.php';

require_login();

$page_title = 'Change Password';
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $message = "New passwords do not match.";
        $message_type = "error";
    } elseif (strlen($new_password) < 8) {
        $message = "Password must be at least 8 characters long.";
        $message_type = "error";
    } else {
        // Verify current password
        $user_id = $_SESSION['user_id'];
        $query = "SELECT password_hash FROM users WHERE user_id = $user_id";
        $result = $conn->query($query);
        $user = $result->fetch_assoc();

        if (password_verify($current_password, $user['password_hash'])) {
            $new_hash = password_hash($new_password, PASSWORD_DEFAULT);
            $conn->query("UPDATE users SET password_hash = '$new_hash', last_password_change = NOW()
                         WHERE user_id = $user_id");

            log_activity($user_id, 'change_password', 'user', $user_id, 'Password changed');

            $message = "Password changed successfully!";
            $message_type = "success";
        } else {
            $message = "Current password is incorrect.";
            $message_type = "error";
        }
    }
}

include '../includes/header.php';
?>

<h2><i class="fas fa-key"></i> Change Password</h2>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $message_type; ?>">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<div class="card" style="max-width: 600px;">
    <div class="card-header"><i class="fas fa-lock"></i> Update Your Password</div>

    <form method="POST" action="">
        <div class="form-group">
            <label for="current_password">Current Password *</label>
            <input type="password" id="current_password" name="current_password" required>
        </div>

        <div class="form-group">
            <label for="new_password">New Password * (minimum 8 characters)</label>
            <input type="password" id="new_password" name="new_password" required minlength="8">
        </div>

        <div class="form-group">
            <label for="confirm_password">Confirm New Password *</label>
            <input type="password" id="confirm_password" name="confirm_password" required minlength="8">
        </div>

        <div style="margin-top: 2rem;">
            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i> Change Password
            </button>
            <a href="../index.php" class="btn btn-secondary">
                <i class="fas fa-times"></i> Cancel
            </a>
        </div>
    </form>
</div>

<?php
$conn->close();
include '../includes/footer.php';
?>
