<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

$page_title = 'Contact Records';
$message = '';
$message_type = '';
$filter_client_id = isset($_GET['client_id']) ? intval($_GET['client_id']) : null;

// Handle new contact record submission
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_contact'])) {
    $client_id = intval($_POST['client_id']);
    $staff_id = intval($_POST['staff_id']);
    $contact_type = sanitize_input($_POST['contact_type']);
    $contact_date = sanitize_input($_POST['contact_date']);
    $subject = sanitize_input($_POST['subject']);
    $description = sanitize_input($_POST['description']);
    $outcome = sanitize_input($_POST['outcome']);
    $follow_up_required = isset($_POST['follow_up_required']) ? 1 : 0;
    $follow_up_date = !empty($_POST['follow_up_date']) ? sanitize_input($_POST['follow_up_date']) : NULL;

    $insert_query = "INSERT INTO contact_records (
        client_id, staff_id, contact_type, contact_date, subject, description,
        outcome, follow_up_required, follow_up_date
    ) VALUES (
        $client_id, $staff_id, '$contact_type', '$contact_date', '$subject',
        '$description', '$outcome', $follow_up_required, " . ($follow_up_date ? "'$follow_up_date'" : "NULL") . "
    )";

    if ($conn->query($insert_query) === TRUE) {
        // Update last contact date for client
        $conn->query("UPDATE clients SET last_contact_date = '$contact_date' WHERE client_id = $client_id");

        $message = "Contact record added successfully!";
        $message_type = "success";
    } else {
        $message = "Error adding contact record: " . $conn->error;
        $message_type = "error";
    }
}

// Get all clients for dropdown
$clients_query = "SELECT client_id, first_name, last_name, email FROM clients ORDER BY last_name, first_name";
$clients_result = $conn->query($clients_query);

// Get all staff for dropdown
$staff_query = "SELECT staff_id, first_name, last_name FROM staff WHERE active = 1 ORDER BY last_name, first_name";
$staff_result = $conn->query($staff_query);

// Get contact records
$contacts_query = "SELECT cr.*,
                   c.first_name as client_first, c.last_name as client_last, c.email as client_email,
                   s.first_name as staff_first, s.last_name as staff_last
                   FROM contact_records cr
                   JOIN clients c ON cr.client_id = c.client_id
                   JOIN staff s ON cr.staff_id = s.staff_id";

if ($filter_client_id) {
    $contacts_query .= " WHERE cr.client_id = $filter_client_id";
}

$contacts_query .= " ORDER BY cr.contact_date DESC";
$contacts_result = $conn->query($contacts_query);

// If filtering by client, get client details
$client_details = null;
if ($filter_client_id) {
    $client_query = "SELECT first_name, last_name, email FROM clients WHERE client_id = $filter_client_id";
    $client_result = $conn->query($client_query);
    if ($client_result->num_rows > 0) {
        $client_details = $client_result->fetch_assoc();
    }
}

include '../includes/header.php';
?>

<h2><i class="fas fa-phone-volume"></i> Contact Records<?php if ($client_details): ?> - <?php echo htmlspecialchars($client_details['first_name'] . ' ' . $client_details['last_name']); ?><?php endif; ?></h2>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $message_type; ?>">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<?php if ($filter_client_id && $client_details): ?>
    <div class="alert alert-info">
        Viewing contact records for: <strong><?php echo htmlspecialchars($client_details['first_name'] . ' ' . $client_details['last_name']); ?></strong>
        (<?php echo htmlspecialchars($client_details['email']); ?>)
        <a href="contact_records.php" class="btn btn-secondary" style="margin-left: 1rem; padding: 0.4rem 0.8rem;">View All Contacts</a>
    </div>
<?php endif; ?>

<div class="card" id="add-contact">
    <div class="card-header"><i class="fas fa-plus-circle"></i> Add New Contact Record</div>

    <form method="POST" action="">
        <input type="hidden" name="add_contact" value="1">

        <div class="form-row">
            <div class="form-group">
                <label for="client_id">Client *</label>
                <select id="client_id" name="client_id" required>
                    <option value="">-- Select Client --</option>
                    <?php
                    mysqli_data_seek($clients_result, 0);
                    while($client = $clients_result->fetch_assoc()):
                    ?>
                        <option value="<?php echo $client['client_id']; ?>"
                                <?php echo ($filter_client_id == $client['client_id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($client['first_name'] . ' ' . $client['last_name'] . ' (' . $client['email'] . ')'); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="staff_id">Staff Member *</label>
                <select id="staff_id" name="staff_id" required>
                    <option value="">-- Select Staff Member --</option>
                    <?php while($staff = $staff_result->fetch_assoc()): ?>
                        <option value="<?php echo $staff['staff_id']; ?>">
                            <?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="contact_type">Contact Type *</label>
                <select id="contact_type" name="contact_type" required>
                    <option value="">-- Select Type --</option>
                    <option value="Newsletter">Newsletter</option>
                    <option value="Phone Call">Phone Call</option>
                    <option value="Visit">Visit</option>
                    <option value="Email">Email</option>
                    <option value="Video Conference">Video Conference</option>
                    <option value="Other">Other</option>
                </select>
            </div>

            <div class="form-group">
                <label for="contact_date">Contact Date & Time *</label>
                <input type="datetime-local" id="contact_date" name="contact_date" required
                       value="<?php echo date('Y-m-d\TH:i'); ?>">
            </div>
        </div>

        <div class="form-group">
            <label for="subject">Subject *</label>
            <input type="text" id="subject" name="subject" required
                   placeholder="Brief subject of the contact">
        </div>

        <div class="form-group">
            <label for="description">Description</label>
            <textarea id="description" name="description" rows="4"
                      placeholder="Detailed description of the contact"></textarea>
        </div>

        <div class="form-group">
            <label for="outcome">Outcome</label>
            <textarea id="outcome" name="outcome" rows="3"
                      placeholder="Result or outcome of the contact"></textarea>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    <input type="checkbox" id="follow_up_required" name="follow_up_required" style="width: auto; margin-right: 0.5rem;">
                    Follow-up Required
                </label>
            </div>

            <div class="form-group">
                <label for="follow_up_date">Follow-up Date</label>
                <input type="date" id="follow_up_date" name="follow_up_date">
            </div>
        </div>

        <div style="margin-top: 1rem;">
            <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Add Contact Record</button>
            <button type="reset" class="btn btn-secondary"><i class="fas fa-eraser"></i> Clear Form</button>
        </div>
    </form>
</div>

<div class="card">
    <div class="card-header"><i class="fas fa-history"></i> Contact History</div>

    <?php if (!$filter_client_id): ?>
        <div style="margin-bottom: 1rem;">
            <label for="filter_client" style="margin-right: 0.5rem;">Filter by Client:</label>
            <select id="filter_client" onchange="if(this.value) window.location.href='contact_records.php?client_id='+this.value; else window.location.href='contact_records.php';" style="width: auto; display: inline-block;">
                <option value="">-- All Clients --</option>
                <?php
                mysqli_data_seek($clients_result, 0);
                while($client = $clients_result->fetch_assoc()):
                ?>
                    <option value="<?php echo $client['client_id']; ?>">
                        <?php echo htmlspecialchars($client['first_name'] . ' ' . $client['last_name']); ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
    <?php endif; ?>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Date & Time</th>
                    <th>Client</th>
                    <th>Type</th>
                    <th>Subject</th>
                    <th>Staff Member</th>
                    <th>Follow-up</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($contacts_result->num_rows > 0): ?>
                    <?php while($contact = $contacts_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo date('Y-m-d H:i', strtotime($contact['contact_date'])); ?></td>
                            <td><?php echo htmlspecialchars($contact['client_first'] . ' ' . $contact['client_last']); ?></td>
                            <td><?php echo $contact['contact_type']; ?></td>
                            <td><?php echo htmlspecialchars($contact['subject']); ?></td>
                            <td><?php echo htmlspecialchars($contact['staff_first'] . ' ' . $contact['staff_last']); ?></td>
                            <td>
                                <?php if ($contact['follow_up_required']): ?>
                                    <span style="color: #e74c3c; font-weight: bold;">Yes</span>
                                    <?php if ($contact['follow_up_date']): ?>
                                        <br><small><?php echo date('Y-m-d', strtotime($contact['follow_up_date'])); ?></small>
                                    <?php endif; ?>
                                <?php else: ?>
                                    No
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="#" onclick="showContactDetails(<?php echo htmlspecialchars(json_encode($contact)); ?>); return false;"
                                   class="btn btn-primary" style="padding: 0.4rem 0.8rem; font-size: 0.9rem;">View</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" style="text-align: center;">No contact records found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal for viewing contact details -->
<div id="contactModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5); z-index: 1000;">
    <div style="background-color: white; margin: 5% auto; padding: 2rem; width: 80%; max-width: 800px; border-radius: 8px; max-height: 80vh; overflow-y: auto;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
            <h3 style="margin: 0;">Contact Details</h3>
            <button onclick="closeContactModal()" style="background: none; border: none; font-size: 1.5rem; cursor: pointer;">&times;</button>
        </div>
        <div id="contactDetails"></div>
        <div style="margin-top: 1.5rem;">
            <button onclick="closeContactModal()" class="btn btn-secondary">Close</button>
        </div>
    </div>
</div>

<script>
function showContactDetails(contact) {
    var details = `
        <div style="line-height: 1.8;">
            <p><strong>Client:</strong> ${contact.client_first} ${contact.client_last} (${contact.client_email})</p>
            <p><strong>Staff Member:</strong> ${contact.staff_first} ${contact.staff_last}</p>
            <p><strong>Contact Type:</strong> ${contact.contact_type}</p>
            <p><strong>Date & Time:</strong> ${new Date(contact.contact_date).toLocaleString()}</p>
            <p><strong>Subject:</strong> ${contact.subject}</p>
            ${contact.description ? `<p><strong>Description:</strong><br>${contact.description.replace(/\n/g, '<br>')}</p>` : ''}
            ${contact.outcome ? `<p><strong>Outcome:</strong><br>${contact.outcome.replace(/\n/g, '<br>')}</p>` : ''}
            <p><strong>Follow-up Required:</strong> ${contact.follow_up_required ? 'Yes' : 'No'}</p>
            ${contact.follow_up_date ? `<p><strong>Follow-up Date:</strong> ${contact.follow_up_date}</p>` : ''}
        </div>
    `;
    document.getElementById('contactDetails').innerHTML = details;
    document.getElementById('contactModal').style.display = 'block';
}

function closeContactModal() {
    document.getElementById('contactModal').style.display = 'none';
}

// Close modal when clicking outside
window.onclick = function(event) {
    var modal = document.getElementById('contactModal');
    if (event.target == modal) {
        closeContactModal();
    }
}
</script>

<?php
$conn->close();
include '../includes/footer.php';
?>
