<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

$page_title = 'Search Clients';
$search_performed = false;
$results = [];

// Handle search
if ($_SERVER['REQUEST_METHOD'] == 'POST' || isset($_GET['search']) || isset($_GET['client_status']) || isset($_GET['kyc_status'])) {
    $search_performed = true;

    $where_clauses = [];

    // Text search (name or email)
    if (!empty($_POST['search_text']) || !empty($_GET['search_text'])) {
        $search_text = sanitize_input($_POST['search_text'] ?? $_GET['search_text']);
        $where_clauses[] = "(c.first_name LIKE '%$search_text%' OR c.last_name LIKE '%$search_text%' OR c.email LIKE '%$search_text%')";
    }

    // Client Status (from POST or GET)
    if (!empty($_POST['client_status']) || !empty($_GET['client_status'])) {
        $client_status = sanitize_input($_POST['client_status'] ?? $_GET['client_status']);
        $where_clauses[] = "c.client_status = '$client_status'";
    }

    // KYC Status (from POST or GET)
    if (!empty($_POST['kyc_status']) || !empty($_GET['kyc_status'])) {
        $kyc_status = sanitize_input($_POST['kyc_status'] ?? $_GET['kyc_status']);
        $where_clauses[] = "c.kyc_status = '$kyc_status'";
    }

    // Risk Rating
    if (!empty($_POST['risk_rating'])) {
        $risk_rating = sanitize_input($_POST['risk_rating']);
        $where_clauses[] = "c.risk_rating = '$risk_rating'";
    }

    // Investment Experience
    if (!empty($_POST['investment_experience'])) {
        $investment_experience = sanitize_input($_POST['investment_experience']);
        $where_clauses[] = "c.investment_experience = '$investment_experience'";
    }

    // Risk Tolerance
    if (!empty($_POST['risk_tolerance'])) {
        $risk_tolerance = sanitize_input($_POST['risk_tolerance']);
        $where_clauses[] = "c.risk_tolerance = '$risk_tolerance'";
    }

    // Investment Horizon
    if (!empty($_POST['investment_horizon'])) {
        $investment_horizon = sanitize_input($_POST['investment_horizon']);
        $where_clauses[] = "c.investment_horizon = '$investment_horizon'";
    }

    // Country
    if (!empty($_POST['country'])) {
        $country = sanitize_input($_POST['country']);
        $where_clauses[] = "c.country LIKE '%$country%'";
    }

    // Assigned Staff
    if (!empty($_POST['assigned_staff_id'])) {
        $assigned_staff_id = intval($_POST['assigned_staff_id']);
        $where_clauses[] = "c.assigned_staff_id = $assigned_staff_id";
    }

    // Investment Interests (keyword search)
    if (!empty($_POST['investment_interests'])) {
        $investment_interests = sanitize_input($_POST['investment_interests']);
        $where_clauses[] = "c.investment_interests LIKE '%$investment_interests%'";
    }

    // Net Worth Range
    if (!empty($_POST['min_net_worth'])) {
        $min_net_worth = floatval($_POST['min_net_worth']);
        $where_clauses[] = "c.total_net_worth >= $min_net_worth";
    }
    if (!empty($_POST['max_net_worth'])) {
        $max_net_worth = floatval($_POST['max_net_worth']);
        $where_clauses[] = "c.total_net_worth <= $max_net_worth";
    }

    // Age Range
    if (!empty($_POST['min_age'])) {
        $min_age = intval($_POST['min_age']);
        $where_clauses[] = "c.age >= $min_age";
    }
    if (!empty($_POST['max_age'])) {
        $max_age = intval($_POST['max_age']);
        $where_clauses[] = "c.age <= $max_age";
    }

    // Build query
    $query = "SELECT c.*,
              s.first_name as staff_first, s.last_name as staff_last,
              o.first_name as owner_first, o.last_name as owner_last,
              i.company_name as introducer_company, i.contact_person as introducer_contact
              FROM clients c
              LEFT JOIN staff s ON c.assigned_staff_id = s.staff_id
              LEFT JOIN staff o ON c.owner_staff_id = o.staff_id
              LEFT JOIN introducers i ON c.introducer_id = i.introducer_id";

    if (count($where_clauses) > 0) {
        $query .= " WHERE " . implode(" AND ", $where_clauses);
    }

    $query .= " ORDER BY c.last_name, c.first_name";

    $result = $conn->query($query);

    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $results[] = $row;
        }
    }
}

// Get staff for dropdown
$staff_query = "SELECT staff_id, first_name, last_name FROM staff WHERE active = 1 ORDER BY last_name, first_name";
$staff_result = $conn->query($staff_query);

// Get unique countries for dropdown
$countries_query = "SELECT DISTINCT country FROM clients WHERE country IS NOT NULL AND country != '' ORDER BY country";
$countries_result = $conn->query($countries_query);

include '../includes/header.php';
?>

<h2><i class="fas fa-search"></i> Search Clients</h2>

<div class="card">
    <div class="card-header"><i class="fas fa-filter"></i> Search Criteria</div>

    <form method="POST" action="">

        <div class="form-row">
            <div class="form-group">
                <label for="search_text">Name or Email</label>
                <input type="text" id="search_text" name="search_text"
                       value="<?php echo htmlspecialchars($_POST['search_text'] ?? ''); ?>"
                       placeholder="Search by name or email">
            </div>

            <div class="form-group">
                <label for="client_status">Client Status</label>
                <select id="client_status" name="client_status">
                    <option value="">-- All Statuses --</option>
                    <option value="Prospect" <?php echo ($_POST['client_status'] ?? '') == 'Prospect' ? 'selected' : ''; ?>>Prospect</option>
                    <option value="Active" <?php echo ($_POST['client_status'] ?? '') == 'Active' ? 'selected' : ''; ?>>Active</option>
                    <option value="Inactive" <?php echo ($_POST['client_status'] ?? '') == 'Inactive' ? 'selected' : ''; ?>>Inactive</option>
                    <option value="Closed" <?php echo ($_POST['client_status'] ?? '') == 'Closed' ? 'selected' : ''; ?>>Closed</option>
                </select>
            </div>

            <div class="form-group">
                <label for="kyc_status">KYC Status</label>
                <select id="kyc_status" name="kyc_status">
                    <option value="">-- All Statuses --</option>
                    <option value="Pending" <?php echo ($_POST['kyc_status'] ?? '') == 'Pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="In Progress" <?php echo ($_POST['kyc_status'] ?? '') == 'In Progress' ? 'selected' : ''; ?>>In Progress</option>
                    <option value="Completed" <?php echo ($_POST['kyc_status'] ?? '') == 'Completed' ? 'selected' : ''; ?>>Completed</option>
                    <option value="Expired" <?php echo ($_POST['kyc_status'] ?? '') == 'Expired' ? 'selected' : ''; ?>>Expired</option>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="risk_rating">Risk Rating</label>
                <select id="risk_rating" name="risk_rating">
                    <option value="">-- All Ratings --</option>
                    <option value="Low" <?php echo ($_POST['risk_rating'] ?? '') == 'Low' ? 'selected' : ''; ?>>Low</option>
                    <option value="Medium" <?php echo ($_POST['risk_rating'] ?? '') == 'Medium' ? 'selected' : ''; ?>>Medium</option>
                    <option value="High" <?php echo ($_POST['risk_rating'] ?? '') == 'High' ? 'selected' : ''; ?>>High</option>
                </select>
            </div>

            <div class="form-group">
                <label for="investment_experience">Investment Experience</label>
                <select id="investment_experience" name="investment_experience">
                    <option value="">-- All Levels --</option>
                    <option value="None" <?php echo ($_POST['investment_experience'] ?? '') == 'None' ? 'selected' : ''; ?>>None</option>
                    <option value="Limited" <?php echo ($_POST['investment_experience'] ?? '') == 'Limited' ? 'selected' : ''; ?>>Limited</option>
                    <option value="Moderate" <?php echo ($_POST['investment_experience'] ?? '') == 'Moderate' ? 'selected' : ''; ?>>Moderate</option>
                    <option value="Extensive" <?php echo ($_POST['investment_experience'] ?? '') == 'Extensive' ? 'selected' : ''; ?>>Extensive</option>
                </select>
            </div>

            <div class="form-group">
                <label for="risk_tolerance">Risk Tolerance</label>
                <select id="risk_tolerance" name="risk_tolerance">
                    <option value="">-- All Levels --</option>
                    <option value="Conservative" <?php echo ($_POST['risk_tolerance'] ?? '') == 'Conservative' ? 'selected' : ''; ?>>Conservative</option>
                    <option value="Moderate" <?php echo ($_POST['risk_tolerance'] ?? '') == 'Moderate' ? 'selected' : ''; ?>>Moderate</option>
                    <option value="Aggressive" <?php echo ($_POST['risk_tolerance'] ?? '') == 'Aggressive' ? 'selected' : ''; ?>>Aggressive</option>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="investment_horizon">Investment Horizon</label>
                <select id="investment_horizon" name="investment_horizon">
                    <option value="">-- All Horizons --</option>
                    <option value="Short-term" <?php echo ($_POST['investment_horizon'] ?? '') == 'Short-term' ? 'selected' : ''; ?>>Short-term</option>
                    <option value="Medium-term" <?php echo ($_POST['investment_horizon'] ?? '') == 'Medium-term' ? 'selected' : ''; ?>>Medium-term</option>
                    <option value="Long-term" <?php echo ($_POST['investment_horizon'] ?? '') == 'Long-term' ? 'selected' : ''; ?>>Long-term</option>
                </select>
            </div>

            <div class="form-group">
                <label for="country">Country</label>
                <select id="country" name="country">
                    <option value="">-- All Countries --</option>
                    <?php while($country_row = $countries_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($country_row['country']); ?>"
                                <?php echo ($_POST['country'] ?? '') == $country_row['country'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($country_row['country']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="assigned_staff_id">Assigned Staff</label>
                <select id="assigned_staff_id" name="assigned_staff_id">
                    <option value="">-- All Staff --</option>
                    <?php while($staff = $staff_result->fetch_assoc()): ?>
                        <option value="<?php echo $staff['staff_id']; ?>"
                                <?php echo ($_POST['assigned_staff_id'] ?? '') == $staff['staff_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="investment_interests">Investment Interests (Keywords)</label>
                <input type="text" id="investment_interests" name="investment_interests"
                       value="<?php echo htmlspecialchars($_POST['investment_interests'] ?? ''); ?>"
                       placeholder="e.g., Equities, Real Estate">
            </div>
        </div>

        <div class="section-title" style="margin-top: 1.5rem;">Financial Ranges</div>

        <div class="form-row">
            <div class="form-group">
                <label for="min_net_worth">Minimum Net Worth</label>
                <input type="number" id="min_net_worth" name="min_net_worth" step="0.01"
                       value="<?php echo htmlspecialchars($_POST['min_net_worth'] ?? ''); ?>"
                       placeholder="e.g., 100000">
            </div>

            <div class="form-group">
                <label for="max_net_worth">Maximum Net Worth</label>
                <input type="number" id="max_net_worth" name="max_net_worth" step="0.01"
                       value="<?php echo htmlspecialchars($_POST['max_net_worth'] ?? ''); ?>"
                       placeholder="e.g., 5000000">
            </div>
        </div>

        <div class="section-title">Age Range</div>

        <div class="form-row">
            <div class="form-group">
                <label for="min_age">Minimum Age</label>
                <input type="number" id="min_age" name="min_age"
                       value="<?php echo htmlspecialchars($_POST['min_age'] ?? ''); ?>"
                       placeholder="e.g., 25">
            </div>

            <div class="form-group">
                <label for="max_age">Maximum Age</label>
                <input type="number" id="max_age" name="max_age"
                       value="<?php echo htmlspecialchars($_POST['max_age'] ?? ''); ?>"
                       placeholder="e.g., 65">
            </div>
        </div>

        <div style="margin-top: 1.5rem;">
            <button type="submit" class="btn btn-primary">Search</button>
            <a href="search_clients.php" class="btn btn-secondary">Clear</a>
        </div>
    </form>
</div>

<?php if ($search_performed): ?>
    <div class="card">
        <div class="card-header">Search Results (<?php echo count($results); ?> clients found)</div>

        <?php if (count($results) > 0): ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>KYC Status</th>
                            <th>Age</th>
                            <th>Net Worth</th>
                            <th>Investment Interests</th>
                            <th>Assigned Staff</th>
                            <th>Owner Staff</th>
                            <th>Introducer Company</th>
                            <th>Introducer Contact</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($results as $client): ?>
                            <tr>
                                <td><?php echo $client['client_id']; ?></td>
                                <td><?php echo htmlspecialchars($client['first_name'] . ' ' . $client['last_name']); ?></td>
                                <td><?php echo htmlspecialchars($client['email']); ?></td>
                                <td><?php echo $client['client_status']; ?></td>
                                <td><?php echo $client['kyc_status']; ?></td>
                                <td><?php echo $client['age'] ?? 'N/A'; ?></td>
                                <td><?php echo $client['total_net_worth'] ? format_currency($client['total_net_worth'], $client['net_worth_currency']) : 'N/A'; ?></td>
                                <td><?php echo htmlspecialchars(substr($client['investment_interests'] ?? '', 0, 50)); ?><?php echo strlen($client['investment_interests'] ?? '') > 50 ? '...' : ''; ?></td>
                                <td><?php echo $client['staff_first'] ? htmlspecialchars($client['staff_first'] . ' ' . $client['staff_last']) : 'Unassigned'; ?></td>
                                <td><?php echo $client['owner_first'] ? htmlspecialchars($client['owner_first'] . ' ' . $client['owner_last']) : 'Unassigned'; ?></td>
                                <td><?php echo $client['introducer_company'] ? htmlspecialchars($client['introducer_company']) : 'N/A'; ?></td>
                                <td><?php echo $client['introducer_contact'] ? htmlspecialchars($client['introducer_contact']) : 'N/A'; ?></td>
                                <td>
                                    <a href="client_form.php?id=<?php echo $client['client_id']; ?>" class="btn btn-primary" style="padding: 0.4rem 0.8rem; font-size: 0.9rem;">View</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="alert alert-info">
                No clients found matching your search criteria.
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php
$conn->close();
include '../includes/footer.php';
?>
