<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

$page_title = 'Staff Management';
$message = '';
$message_type = '';
$edit_mode = false;
$staff_data = [];

// Handle staff form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $first_name = sanitize_input($_POST['first_name']);
    $last_name = sanitize_input($_POST['last_name']);
    $email = sanitize_input($_POST['email']);
    $phone = sanitize_input($_POST['phone']);
    $department = sanitize_input($_POST['department']);
    $position = sanitize_input($_POST['position']);
    $active = isset($_POST['active']) ? 1 : 0;

    if (isset($_POST['staff_id']) && !empty($_POST['staff_id'])) {
        // Update existing staff
        $staff_id = intval($_POST['staff_id']);
        $update_query = "UPDATE staff SET
            first_name = '$first_name',
            last_name = '$last_name',
            email = '$email',
            phone = '$phone',
            department = '$department',
            position = '$position',
            active = $active
            WHERE staff_id = $staff_id";

        if ($conn->query($update_query) === TRUE) {
            $message = "Staff member updated successfully!";
            $message_type = "success";
        } else {
            $message = "Error updating staff member: " . $conn->error;
            $message_type = "error";
        }
    } else {
        // Insert new staff
        $insert_query = "INSERT INTO staff (first_name, last_name, email, phone, department, position, active)
                        VALUES ('$first_name', '$last_name', '$email', '$phone', '$department', '$position', $active)";

        if ($conn->query($insert_query) === TRUE) {
            $message = "Staff member added successfully!";
            $message_type = "success";
        } else {
            $message = "Error adding staff member: " . $conn->error;
            $message_type = "error";
        }
    }
}

// Handle edit request
if (isset($_GET['edit'])) {
    $edit_mode = true;
    $staff_id = intval($_GET['edit']);
    $query = "SELECT * FROM staff WHERE staff_id = $staff_id";
    $result = $conn->query($query);
    if ($result->num_rows > 0) {
        $staff_data = $result->fetch_assoc();
    }
}

// Get all staff members
$staff_query = "SELECT s.*,
                COUNT(c.client_id) as client_count
                FROM staff s
                LEFT JOIN clients c ON s.staff_id = c.assigned_staff_id
                GROUP BY s.staff_id
                ORDER BY s.last_name, s.first_name";
$staff_result = $conn->query($staff_query);

include '../includes/header.php';
?>

<h2><i class="fas fa-users-cog"></i> Staff Management</h2>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $message_type; ?>">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header"><i class="fas fa-user-tie"></i> <?php echo $edit_mode ? 'Edit Staff Member' : 'Add New Staff Member'; ?></div>

    <form method="POST" action="">
        <?php if ($edit_mode): ?>
            <input type="hidden" name="staff_id" value="<?php echo $staff_data['staff_id']; ?>">
        <?php endif; ?>

        <div class="form-row">
            <div class="form-group">
                <label for="first_name">First Name *</label>
                <input type="text" id="first_name" name="first_name" required
                       value="<?php echo htmlspecialchars($staff_data['first_name'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="last_name">Last Name *</label>
                <input type="text" id="last_name" name="last_name" required
                       value="<?php echo htmlspecialchars($staff_data['last_name'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="email">Email *</label>
                <input type="email" id="email" name="email" required
                       value="<?php echo htmlspecialchars($staff_data['email'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="tel" id="phone" name="phone"
                       value="<?php echo htmlspecialchars($staff_data['phone'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="department">Department</label>
                <input type="text" id="department" name="department"
                       value="<?php echo htmlspecialchars($staff_data['department'] ?? ''); ?>"
                       placeholder="e.g., Client Relations, Wealth Management">
            </div>

            <div class="form-group">
                <label for="position">Position</label>
                <input type="text" id="position" name="position"
                       value="<?php echo htmlspecialchars($staff_data['position'] ?? ''); ?>"
                       placeholder="e.g., Senior Advisor, Portfolio Manager">
            </div>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" id="active" name="active" style="width: auto; margin-right: 0.5rem;"
                       <?php echo ($staff_data['active'] ?? 1) ? 'checked' : ''; ?>>
                Active
            </label>
            <small style="display: block; margin-top: 0.25rem; color: #666;">Inactive staff members will not appear in dropdown lists</small>
        </div>

        <div style="margin-top: 1.5rem;">
            <button type="submit" class="btn btn-success">
                <i class="fas fa-<?php echo $edit_mode ? 'save' : 'user-plus'; ?>"></i>
                <?php echo $edit_mode ? 'Update Staff Member' : 'Add Staff Member'; ?>
            </button>
            <?php if ($edit_mode): ?>
                <a href="staff_management.php" class="btn btn-secondary"><i class="fas fa-times"></i> Cancel Edit</a>
            <?php else: ?>
                <button type="reset" class="btn btn-secondary"><i class="fas fa-eraser"></i> Clear Form</button>
            <?php endif; ?>
        </div>
    </form>
</div>

<div class="card">
    <div class="card-header"><i class="fas fa-list"></i> All Staff Members</div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Department</th>
                    <th>Position</th>
                    <th>Assigned Clients</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($staff_result->num_rows > 0): ?>
                    <?php while($staff = $staff_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $staff['staff_id']; ?></td>
                            <td><?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?></td>
                            <td><?php echo htmlspecialchars($staff['email']); ?></td>
                            <td><?php echo htmlspecialchars($staff['phone'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($staff['department'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($staff['position'] ?? 'N/A'); ?></td>
                            <td><?php echo $staff['client_count']; ?></td>
                            <td>
                                <?php if ($staff['active']): ?>
                                    <span style="color: #27ae60; font-weight: bold;">Active</span>
                                <?php else: ?>
                                    <span style="color: #95a5a6;">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="staff_management.php?edit=<?php echo $staff['staff_id']; ?>"
                                   class="btn btn-primary" style="padding: 0.4rem 0.8rem; font-size: 0.9rem;">Edit</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="9" style="text-align: center;">No staff members found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
$conn->close();
include '../includes/footer.php';
?>
