# Image Assets Directory

This directory contains all image assets for the Oasis Investor Database System.

## Structure

```
image/
└── logo/
    └── OCFLoogo.png  ⬅️ Upload your company logo here
```

## Logo Requirements

**Filename:** `OCFLoogo.png` (exact spelling required)

**Specifications:**
- Format: PNG with transparent background
- Recommended size: 200px × 50px (4:1 ratio)
- Maximum file size: 100KB
- Background: Transparent (preferred) or white
- Color scheme: Should work on dark blue background

**Display:**
- Navigation bar (all pages)
- Scales to 50px height on desktop
- Responsive sizing on mobile devices

## Additional Assets

You can add more images to this directory for:
- Background images
- Icons
- Illustrations
- User uploads (create subdirectories as needed)

## File Naming

Use lowercase with hyphens for new files:
- ✓ `company-banner.png`
- ✓ `user-avatar-default.jpg`
- ✗ `CompanyBanner.PNG`
- ✗ `user avatar default.jpg`

---

For logo setup instructions, see: `BRANDING_SETUP.md`
