<?php
// Load authentication
$auth_path = (strpos(dirname($_SERVER['PHP_SELF']), '/forms') !== false) ? '../includes/auth.php' : 'includes/auth.php';
require_once $auth_path;

// Require login for all pages except login, logout, and access denied
$public_pages = ['login.php', 'logout.php', 'access_denied.php'];
$current_page = basename($_SERVER['PHP_SELF']);
if (!in_array($current_page, $public_pages)) {
    require_login();
}

if (!isset($page_title)) {
    $page_title = 'Investor Database System';
}
// Determine the base path based on current location
$current_dir = dirname($_SERVER['PHP_SELF']);
$base_path = (strpos($current_dir, '/forms') !== false) ? '../' : '';

// Get current user
$current_user = get_authenticated_user();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - <?php echo APP_NAME; ?></title>
    <link rel="icon" type="image/png" href="<?php echo $base_path; ?>favicon.png">
    <link rel="stylesheet" href="<?php echo $base_path; ?>css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <a href="<?php echo $base_path; ?>index.php" class="brand-link">
                    <img src="<?php echo $base_path; ?>image/logo/OCFLoogo.png" alt="Oasis Logo" class="brand-logo">
                    <span><?php echo APP_NAME; ?></span>
                </a>
            </div>
            <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">
                <i class="fas fa-bars"></i>
            </button>
            <ul class="nav-menu" id="navMenu">
                <li>
                    <a href="<?php echo $base_path; ?>index.php" class="nav-link">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li class="nav-dropdown">
                    <a href="#" class="nav-link dropdown-trigger">
                        <i class="fas fa-users"></i>
                        <span>Clients</span>
                        <i class="fas fa-chevron-down dropdown-arrow"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="<?php echo $base_path; ?>forms/client_form.php"><i class="fas fa-user-plus"></i> Add New Client</a></li>
                        <li><a href="<?php echo $base_path; ?>forms/search_clients.php"><i class="fas fa-search"></i> Search Clients</a></li>
                        <li><a href="<?php echo $base_path; ?>forms/search_clients.php?client_status=Active"><i class="fas fa-check-circle"></i> Active Clients</a></li>
                        <li><a href="<?php echo $base_path; ?>forms/search_clients.php?client_status=Prospect"><i class="fas fa-user-clock"></i> Prospects</a></li>
                    </ul>
                </li>
                <li class="nav-dropdown">
                    <a href="#" class="nav-link dropdown-trigger">
                        <i class="fas fa-phone-alt"></i>
                        <span>Contacts</span>
                        <i class="fas fa-chevron-down dropdown-arrow"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="<?php echo $base_path; ?>forms/contact_records.php"><i class="fas fa-list"></i> All Contacts</a></li>
                        <li><a href="<?php echo $base_path; ?>forms/contact_records.php#add-contact"><i class="fas fa-plus-circle"></i> Add Contact Record</a></li>
                    </ul>
                </li>
                <li class="nav-dropdown">
                    <a href="#" class="nav-link dropdown-trigger">
                        <i class="fas fa-users-cog"></i>
                        <span>Management</span>
                        <i class="fas fa-chevron-down dropdown-arrow"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="<?php echo $base_path; ?>forms/staff_management.php"><i class="fas fa-user-tie"></i> Staff</a></li>
                        <li><a href="<?php echo $base_path; ?>forms/introducers_list.php"><i class="fas fa-handshake"></i> Introducers</a></li>
                        <li><a href="<?php echo $base_path; ?>forms/introducer_form.php"><i class="fas fa-plus-circle"></i> Add Introducer</a></li>
                        <?php if (has_role('Admin')): ?>
                        <li><a href="<?php echo $base_path; ?>forms/user_management.php"><i class="fas fa-users"></i> Users</a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                <li class="nav-dropdown">
                    <a href="#" class="nav-link dropdown-trigger">
                        <i class="fas fa-user-circle"></i>
                        <span><?php echo htmlspecialchars($current_user['first_name'] ?? 'User'); ?></span>
                        <i class="fas fa-chevron-down dropdown-arrow"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li style="padding: 0.75rem 1.25rem; background: #f8f9fa; border-bottom: 1px solid #e1e8ed;">
                            <div style="font-size: 0.85rem; color: #6c757d;">Logged in as</div>
                            <div style="font-weight: 600; color: #2c3e50;"><?php echo htmlspecialchars($current_user['username'] ?? ''); ?></div>
                            <div style="font-size: 0.85rem; color: #6c757d;"><?php echo htmlspecialchars($current_user['role'] ?? ''); ?></div>
                        </li>
                        <li><a href="<?php echo $base_path; ?>forms/profile.php"><i class="fas fa-user"></i> My Profile</a></li>
                        <li><a href="<?php echo $base_path; ?>forms/change_password.php"><i class="fas fa-key"></i> Change Password</a></li>
                        <?php if (has_role('Admin')): ?>
                        <li><a href="<?php echo $base_path; ?>forms/activity_log.php"><i class="fas fa-history"></i> Activity Log</a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo $base_path; ?>logout.php" style="color: #e74c3c;"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
    <div class="container main-content">

    <script>
    function toggleMobileMenu() {
        const menu = document.getElementById('navMenu');
        menu.classList.toggle('active');
    }

    // Dropdown menu functionality
    document.addEventListener('DOMContentLoaded', function() {
        const dropdownTriggers = document.querySelectorAll('.dropdown-trigger');

        dropdownTriggers.forEach(trigger => {
            trigger.addEventListener('click', function(e) {
                e.preventDefault();
                const parent = this.parentElement;
                const wasActive = parent.classList.contains('active');

                // Close all dropdowns
                document.querySelectorAll('.nav-dropdown').forEach(dropdown => {
                    dropdown.classList.remove('active');
                });

                // Toggle current dropdown
                if (!wasActive) {
                    parent.classList.add('active');
                }
            });
        });

        // Close dropdowns when clicking outside
        document.addEventListener('click', function(e) {
            if (!e.target.closest('.nav-dropdown')) {
                document.querySelectorAll('.nav-dropdown').forEach(dropdown => {
                    dropdown.classList.remove('active');
                });
            }
        });
    });
    </script>
